﻿// ****************************************************************************
///*!	\file DateTimeExtension.cs
// *	\brief Functions to help with DateTime objects (Round/Floor/Ceiling
// *
// *	\copyright	Copyright 2012-2017 FlexRadio Systems.  All Rights Reserved.
// *				Unauthorized use, duplication or distribution of this software is
// *				strictly prohibited by law.
// *
// *	\date 2014-04-02
// *	\author Eric Wachsmann, KE5DTO
// */
// ****************************************************************************


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Flex.Util
{
    public static class DateTimeExtension
    {
        public static DateTime Round(this DateTime date, TimeSpan span)
        {
            long ticks = (date.Ticks + (span.Ticks / 2) + 1) / span.Ticks;
            return new DateTime(ticks * span.Ticks);
        }

        public static DateTime Floor(this DateTime date, TimeSpan span)
        {
            long ticks = (date.Ticks / span.Ticks);
            return new DateTime(ticks * span.Ticks);
        }

        public static DateTime Ceiling(this DateTime date, TimeSpan span)
        {
            long ticks = (date.Ticks + span.Ticks - 1) / span.Ticks;
            return new DateTime(ticks * span.Ticks);
        }
    }
}
